	%  Example 9.1 Impulse response-invariant design
	clear all
	close all
	clc
	wc = 1; ws = 2; Amax = -10*log10(1-0.5^2);	Amin = 50;
	N = CA_ORDER_S(wc, ws, Amax, Amin);
	N = 4;
	[G, Z, R_ZEROS, P, wsnew] = CA_POLES_S(wc, ws, Amax, Amin, N)
	t_axis = [0:0.1:30];
	[h, dirac0, t_axis] = PZ_2_IMPULSE_RESPONSE_S(G, Z, P, t_axis);
	dirac0
	figure(1); subplot('position', [0.1 0.4 0.86 0.5]);
	PLOT_IMPULSE_RESPONSE_S(h, dirac0, t_axis), hold on
	for m = 1:30
		hi(m+1) = h(10*m);	% Sample the impulse response h(t)
	end
	PLOT_IMPULSE_RESPONSE_Z(hi)
	N = length(hi);	
	wT = linspace(0, pi, 1000);
	[Gd, Zd, Pd] = IMPULSE_2_P_Z(hi, N)
	Taug = PZ_2_TG_Z(Gd, Zd, Pd, wT);
	Att = PZ_2_ATT_Z(Gd, Zd, Pd, wT); 
	figure(2); subplot('position', [0.1 0.4 0.86 0.5]);
	PLOT_ATT_TG_Z(Att, Taug, wT, 60, 15)
	% Standard settings
	fs = 16; % Font size
	lw = 1; % Linewidth
	fn = 'times'; % Font
	text(0.7, 0.1,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	text(0.7, -19,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
		
